/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.Random;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class SpawnerRandomizingProcessor
extends StructureProcessor {
    public static final Codec<SpawnerRandomizingProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf("rs_spawner_resourcelocation").forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.rsSpawnerResourcelocation)).apply((Applicative)instance, instance.stable(SpawnerRandomizingProcessor::new)));
    public final ResourceLocation rsSpawnerResourcelocation;

    private SpawnerRandomizingProcessor(ResourceLocation rsSpawnerResourcelocation) {
        this.rsSpawnerResourcelocation = rsSpawnerResourcelocation;
    }

    public Template.BlockInfo func_230386_a_(IWorldReader worldView, BlockPos pos, BlockPos blockPos, Template.BlockInfo structureBlockInfoLocal, Template.BlockInfo structureBlockInfoWorld, PlacementSettings structurePlacementData) {
        if (structureBlockInfoWorld.field_186243_b.func_177230_c() instanceof SpawnerBlock) {
            BlockPos worldPos = structureBlockInfoWorld.field_186242_a;
            SharedSeedRandom random = new SharedSeedRandom();
            random.setSeed(worldPos.func_218275_a() * (long)worldPos.func_177956_o());
            return new Template.BlockInfo(worldPos, structureBlockInfoWorld.field_186243_b, this.SetMobSpawnerEntity((Random)random, structureBlockInfoWorld.field_186244_c));
        }
        return structureBlockInfoWorld;
    }

    private CompoundNBT SetMobSpawnerEntity(Random random, CompoundNBT nbt) {
        EntityType<?> entity = RepurposedStructures.mobSpawnerManager.getSpawnerMob(this.rsSpawnerResourcelocation, random);
        if (entity != null) {
            if (nbt != null) {
                CompoundNBT spawnDataTag = nbt.func_74775_l("SpawnData");
                if (spawnDataTag.isEmpty()) {
                    spawnDataTag = new CompoundNBT();
                    nbt.func_218657_a("SpawnData", (INBT)spawnDataTag);
                }
                spawnDataTag.func_74778_a("id", Registry.field_212629_r.func_177774_c(entity).toString());
                CompoundNBT spawnEntityDataTag = new CompoundNBT();
                spawnEntityDataTag.func_74778_a("id", Registry.field_212629_r.func_177774_c(entity).toString());
                CompoundNBT spawnPotentialEntryTag = new CompoundNBT();
                spawnPotentialEntryTag.func_218657_a("Entity", (INBT)spawnEntityDataTag);
                spawnPotentialEntryTag.func_218657_a("Weight", (INBT)IntNBT.func_229692_a_((int)1));
                ListNBT spawnPotentialDataTag = nbt.func_150295_c("SpawnPotentials", (int)spawnPotentialEntryTag.func_74732_a());
                if (spawnPotentialDataTag.isEmpty()) {
                    spawnPotentialDataTag = new ListNBT();
                    nbt.func_218657_a("SpawnPotentials", (INBT)spawnPotentialDataTag);
                }
                spawnPotentialDataTag.clear();
                spawnPotentialDataTag.add(0, (INBT)spawnPotentialEntryTag);
                return nbt;
            }
            CompoundNBT compound = new CompoundNBT();
            compound.func_74777_a("Delay", (short)20);
            compound.func_74777_a("MinSpawnDelay", (short)200);
            compound.func_74777_a("MaxSpawnDelay", (short)800);
            compound.func_74777_a("SpawnCount", (short)4);
            compound.func_74777_a("MaxNearbyEntities", (short)6);
            compound.func_74777_a("RequiredPlayerRange", (short)16);
            compound.func_74777_a("SpawnRange", (short)4);
            CompoundNBT spawnData = new CompoundNBT();
            spawnData.func_74778_a("id", Registry.field_212629_r.func_177774_c(entity).toString());
            compound.func_218657_a("SpawnData", (INBT)spawnData);
            CompoundNBT entityData = new CompoundNBT();
            entityData.func_74778_a("id", Registry.field_212629_r.func_177774_c(entity).toString());
            CompoundNBT listEntry = new CompoundNBT();
            listEntry.func_218657_a("Entity", (INBT)entityData);
            listEntry.func_74768_a("Weight", 1);
            ListNBT listnbt = new ListNBT();
            listnbt.add((Object)listEntry);
            compound.func_218657_a("SpawnPotentials", (INBT)listnbt);
            return compound;
        }
        RepurposedStructures.LOGGER.warn("EntityType in a dungeon does not exist in registry! : {}", (Object)this.rsSpawnerResourcelocation);
        return nbt;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return RSProcessors.SPAWNER_RANDOMIZING_PROCESSOR;
    }
}

